/** \file com_io.c
 * \brief  -  USART
 * \par
 *  "  "   printf()  ..
 *    ,   #BAUD,   USART1 (  2)
 * \par
 * \author ARV
 * \note
 * \n :
 * \n \date	05.02.2009 ... 	__.__.2008
 * \par
 * \version 1.0 beta	\n
 * Copyright 2008  ARV. All rights reserved. </b>
 * \par
 *   :\n
 * 	-# WinAVR-20080411    
 *
 */
#include <avr/io.h>
#include <avr/wdt.h>
#include <util/delay.h>
#include "com_io.h"

///  
static int uart_putchar(char c, FILE *stream);
#if ONLY_OUT == 0
static int uart_getchar(FILE *stream);
#endif

///   -
#if ONLY_OUT != 0
static FILE mystdout = FDEV_SETUP_STREAM(uart_putchar, NULL, _FDEV_SETUP_WRITE);
#else
static FILE mystdout = FDEV_SETUP_STREAM(uart_putchar, uart_getchar, _FDEV_SETUP_RW);
#endif

/**         ( )
 *
 * @param c  
 * @param stream   
 * @return   0
 */
static int uart_putchar(char c, FILE *stream){
  if (c == '\n')
	uart_putchar('\r', stream);
  while(bit_is_clear(UCSRA, UDRE))
#if USE_WDT != 0
	  wdt_reset();
#endif
  ;
  UDR = c;
  return 0;
}

#if ONLY_OUT == 0
static int uart_getchar(FILE *stream){
	while(bit_is_clear(UCSRA, RXC))
#if USE_WDT != 0
	  wdt_reset();
#endif
	;
	return UDR;
}
#endif

void print_line(char c, uint8_t count){
	while(count--)putchar(c);
}


/**   .
 *
 */
///    USART   -.
__attribute__((naked, section(".init7")))
void init_io(void){
	///        .
   UCSRA = 0;
   UCSRB = 8;
#include <util/setbaud.h>
   UBRRH = UBRRH_VALUE;
   UBRRL = UBRRL_VALUE;
#if USE_2X
   UCSRA |= (1 << U2X);
#else
   UCSRA &= ~(1 << U2X);
#endif
   UCSRB |= _BV(TXEN);
#if ONLY_OUT == 0
   UCSRB |= _BV(RXEN);
#endif
   UCSRC = 0x86;

   stdout = &mystdout;
   stdin = stdout;
}




