/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cross.arm.gnu;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedCommandLineGenerator;

public class ARMManagedCommandLineGenerator
extends ManagedCommandLineGenerator {
    private static final String OPTION_SUFIX_PROCESSOR = ".option.target.processor";
    private static final String OPTION_SUFIX_THUMB = ".option.target.thumb";
    private static final String OPTION_SUFIX_THUMB_INTERWORK = ".option.target.thumbinterwork";
    private static final String OPTION_SUFIX_DEBUGGING_LEVEL = ".option.debugging.level";
    private static final String OPTION_SUFIX_DEBUGGING_FORMAT = ".option.debugging.format";
    private static final String OPTION_SUFIX_DEBUGGING_OTHER = ".option.debugging.other";
    private static final String OPTION_SUFIX_DEBUGGING_PROF = ".option.debugging.prof";
    private static final String OPTION_SUFIX_DEBUGGING_GPROF = ".option.debugging.gprof";
    private static final boolean DEBUG_LOCAL = false;

    public IManagedCommandLineInfo generateCommandLineInfo(ITool oTool, String sCommandName, String[] asFlags, String sOutputFlag, String sOutputPrefix, String sOutputName, String[] asInputResources, String sCommandLinePattern) {
        return this.generateCommandLineInfo(oTool, sCommandName, asFlags, sOutputFlag, sOutputPrefix, sOutputName, asInputResources, sCommandLinePattern, false);
    }

    public IManagedCommandLineInfo generateCommandLineInfo(ITool oTool, String sCommandName, String[] asFlags, String sOutputFlag, String sOutputPrefix, String sOutputName, String[] asInputResources, String sCommandLinePattern, boolean bFlag) {
        ArrayList<String> oList = new ArrayList<String>();
        oList.addAll(Arrays.asList(asFlags));
        Object oParent = oTool.getParent();
        while (oParent != null && !(oParent instanceof IToolChain)) {
            ITool oSuper = oTool.getSuperClass();
            oParent = oSuper != null && oSuper instanceof ITool ? oSuper.getParent() : null;
        }
        if (oParent != null && oParent instanceof IToolChain) {
            IToolChain oToolChain = (IToolChain)oParent;
            IOption[] aoOptions = oToolChain.getOptions();
            String sProcessor = null;
            String sThumb = null;
            String sThumbInterwork = null;
            String sDebugLevel = null;
            String sDebugFormat = null;
            String sDebugOther = null;
            String sDebugProf = null;
            String sDebugGProf = null;
            int i = 0;
            while (i < aoOptions.length) {
                IOption oOption = aoOptions[i];
                String sID = oOption.getId();
                Object oValue = oOption.getValue();
                String sCommand = oOption.getCommand();
                if (oValue instanceof String) {
                    String sEnumCommand;
                    String sVal;
                    try {
                        sVal = oOption.getStringValue();
                    }
                    catch (BuildException buildException) {
                        sVal = null;
                    }
                    try {
                        sEnumCommand = oOption.getEnumCommand(sVal);
                    }
                    catch (BuildException buildException) {
                        sEnumCommand = null;
                    }
                    if (sID.endsWith(OPTION_SUFIX_PROCESSOR) || sID.indexOf(".option.target.processor.") > 0) {
                        sProcessor = sEnumCommand;
                    } else if (sID.endsWith(OPTION_SUFIX_DEBUGGING_LEVEL) || sID.indexOf(".option.debugging.level.") > 0) {
                        sDebugLevel = sEnumCommand;
                    } else if (sID.endsWith(OPTION_SUFIX_DEBUGGING_FORMAT) || sID.indexOf(".option.debugging.format.") > 0) {
                        sDebugFormat = sEnumCommand;
                    } else if (sID.endsWith(OPTION_SUFIX_DEBUGGING_OTHER) || sID.indexOf(".option.debugging.other.") > 0) {
                        sDebugOther = sVal;
                    }
                } else if (oValue instanceof Boolean) {
                    boolean bVal;
                    try {
                        bVal = oOption.getBooleanValue();
                    }
                    catch (BuildException buildException) {
                        bVal = false;
                    }
                    if (sID.endsWith(OPTION_SUFIX_THUMB) || sID.indexOf(".option.target.thumb.") > 0) {
                        if (bVal) {
                            sThumb = sCommand;
                        }
                    } else if (sID.endsWith(OPTION_SUFIX_THUMB_INTERWORK) || sID.indexOf(".option.target.thumbinterwork.") > 0) {
                        if (bVal) {
                            sThumbInterwork = sCommand;
                        }
                    } else if (sID.endsWith(OPTION_SUFIX_DEBUGGING_PROF) || sID.indexOf(".option.debugging.prof.") > 0) {
                        if (bVal) {
                            sDebugProf = sCommand;
                        }
                    } else if ((sID.endsWith(OPTION_SUFIX_DEBUGGING_GPROF) || sID.indexOf(".option.debugging.gprof.") > 0) && bVal) {
                        sDebugGProf = sCommand;
                    }
                }
                ++i;
            }
            if (sProcessor != null && sProcessor.length() > 0) {
                oList.add(sProcessor);
            }
            if (sThumb != null && sThumb.length() > 0) {
                oList.add(sThumb);
            }
            if (sThumbInterwork != null && sThumbInterwork.length() > 0) {
                oList.add(sThumbInterwork);
            }
            if (sDebugLevel != null && sDebugLevel.length() > 0) {
                oList.add(sDebugLevel);
                if (sDebugFormat != null && sDebugFormat.length() > 0) {
                    oList.add(sDebugFormat);
                }
            }
            if (sDebugOther != null && sDebugOther.length() > 0) {
                oList.add(sDebugOther);
            }
            if (sDebugProf != null && sDebugProf.length() > 0) {
                oList.add(sDebugProf);
            }
            if (sDebugGProf != null && sDebugGProf.length() > 0) {
                oList.add(sDebugGProf);
            }
        }
        return super.generateCommandLineInfo(oTool, sCommandName, oList.toArray(new String[0]), sOutputFlag, sOutputPrefix, sOutputName, asInputResources, sCommandLinePattern);
    }
}

