/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cross.arm.gnu;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.osgi.framework.BundleContext;

public class ARMPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.cdt.cross.arm.gnu";
    public static final String DEFAULT_LOG = "ARM Eclipse Plugin Log";
    private static ARMPlugin m_oPlugin;

    public void start(BundleContext oContext) throws Exception {
        super.start(oContext);
        m_oPlugin = this;
    }

    public void stop(BundleContext oContext) throws Exception {
        m_oPlugin = null;
        super.stop(oContext);
    }

    public static ARMPlugin getDefault() {
        return m_oPlugin;
    }

    public void log(IStatus oStatus) {
        ILog oLog = this.getLog();
        if (oStatus.getSeverity() >= 2) {
            oLog.log(oStatus);
        }
        if (this.isDebugging()) {
            System.err.print("org.eclipse.cdt.cross.arm.gnu: " + oStatus.getMessage());
            if (oStatus.getCode() != 0) {
                System.err.print("(" + oStatus.getCode() + ")");
            }
            System.out.println("");
            if (oStatus.getException() != null) {
                oStatus.getException().printStackTrace();
            }
        }
    }

    public static void log(String sMsg, Exception oException) {
        ARMPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, sMsg, (Throwable)oException));
    }

    public MessageConsole getDefaultConsole() {
        return this.getConsole(DEFAULT_LOG);
    }

    public MessageConsole getConsole(String sName) {
        IConsole[] aoConsoles;
        IConsoleManager oConMan = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = aoConsoles = oConMan.getConsoles();
        int n = aoConsoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole oConsole = iConsoleArray[n2];
            if (oConsole.getName().equals(sName)) {
                return (MessageConsole)oConsole;
            }
            ++n2;
        }
        MessageConsole oNewConsole = new MessageConsole(sName, null);
        oConMan.addConsoles(new IConsole[]{oNewConsole});
        return oNewConsole;
    }
}

