/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cross.arm.gnu;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.gnu.ui.GnuUIPlugin;
import org.eclipse.cdt.utils.WindowsRegistry;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Tools {
    private static final String PROPERTY_OS_NAME = "os.name";
    public static final String PROPERTY_OS_VALUE_WINDOWS = "windows";
    public static final String PROPERTY_OS_VALUE_LINUX = "linux";
    public static final String PROPERTY_OS_VALUE_MACOSX = "macosx";
    private static final String SP = " ";

    public static boolean isPlatform(String sPlatform) {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(sPlatform);
    }

    public static boolean isWindows() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE_WINDOWS);
    }

    public static boolean isLinux() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE_LINUX);
    }

    public static boolean isMacOSX() {
        return System.getProperty(PROPERTY_OS_NAME).toLowerCase().startsWith(PROPERTY_OS_VALUE_MACOSX);
    }

    public static String getManualInstallPath(String check) {
        String installPath;
        block5: {
            installPath = null;
            if (check == null || check.isEmpty()) {
                return installPath;
            }
            try {
                String[] paths;
                String sysPath = null;
                sysPath = System.getenv("PATH");
                String delim = System.getProperty("path.separator");
                if (delim == null || delim.length() <= 0 || sysPath == null || sysPath.length() <= 0 || (paths = sysPath.split(delim)) == null || paths.length <= 0) break block5;
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (p.contains(check)) {
                        int start = p.indexOf(check);
                        installPath = p.substring(0, start + check.length());
                        GnuUIPlugin.getDefault();
                        GnuUIPlugin.getDefault().log((IStatus)new Status(0, "org.eclipse.cdt.cross.arm.gnu", "getManualInstallPath(): " + installPath));
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                GnuUIPlugin.getDefault().log((Throwable)e);
            }
        }
        return installPath;
    }

    public static String[] exec(String cmd, IConfiguration cfg, String sBinPath) {
        try {
            IEnvironmentVariable[] vars = ManagedBuildManager.getEnvironmentVariableProvider().getVariables(cfg, true);
            String[] env = new String[vars.length];
            int i = 0;
            while (i < env.length) {
                env[i] = String.valueOf(vars[i].getName()) + "=";
                String value = vars[i].getValue();
                if (value != null) {
                    int n = i;
                    env[n] = String.valueOf(env[n]) + value;
                }
                ++i;
            }
            Process proc = ProcessFactory.getFactory().exec(cmd.split(SP), env);
            if (proc != null) {
                String s;
                InputStream ein = proc.getInputStream();
                BufferedReader d1 = new BufferedReader(new InputStreamReader(ein));
                ArrayList<String> ls = new ArrayList<String>(10);
                while ((s = d1.readLine()) != null) {
                    ls.add(s);
                }
                ein.close();
                return ls.toArray(new String[0]);
            }
        }
        catch (IOException e) {
            GnuUIPlugin.getDefault().log((Throwable)e);
        }
        return null;
    }

    public static String getLocalMachineValue(String sKey, String sName) {
        String s;
        WindowsRegistry registry = WindowsRegistry.getRegistry();
        if (registry != null && (s = registry.getLocalMachineValue(sKey, sName)) != null) {
            return s;
        }
        return null;
    }
}

