/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cross.arm.gnu.scannerconfig;

import org.eclipse.cdt.build.core.scannerconfig.CfgInfoContext;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector;
import org.eclipse.cdt.make.core.scannerconfig.InfoContext;
import org.eclipse.cdt.make.internal.core.scannerconfig.gnu.GCCScannerInfoConsoleParser;
import org.eclipse.cdt.make.internal.core.scannerconfig2.PerProjectSICollector;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;

public class ARMManagedGCCScannerInfoConsoleParser
extends GCCScannerInfoConsoleParser {
    Boolean m_bManagedBuildOnState;

    public boolean processLine(String sLine) {
        if (this.isManagedBuildOn()) {
            return false;
        }
        return super.processLine(sLine);
    }

    public void shutdown() {
        if (!this.isManagedBuildOn()) {
            super.shutdown();
        }
        this.m_bManagedBuildOnState = null;
    }

    public void startup(IProject oProject, IScannerInfoCollector oCollector) {
        if (this.isManagedBuildOn()) {
            return;
        }
        super.startup(oProject, oCollector);
    }

    protected boolean isManagedBuildOn() {
        if (this.m_bManagedBuildOnState == null) {
            this.m_bManagedBuildOnState = this.doCalcManagedBuildOnState();
        }
        return this.m_bManagedBuildOnState;
    }

    protected boolean doCalcManagedBuildOnState() {
        IScannerInfoCollector oCr = this.getCollector();
        if (!(oCr instanceof PerProjectSICollector)) {
            return false;
        }
        InfoContext oC = ((PerProjectSICollector)oCr).getContext();
        IProject oProject = oC.getProject();
        ICProjectDescription oDes = CoreModel.getDefault().getProjectDescription(oProject, false);
        CfgInfoContext oCc = CfgInfoContext.fromInfoContext((ICProjectDescription)oDes, (InfoContext)oC);
        if (oCc != null) {
            IConfiguration cfg = oCc.getConfiguration();
            return cfg.isManagedBuildOn();
        }
        return false;
    }
}

