/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.cross.arm.gnu.yagarto.windows;

import org.eclipse.cdt.cross.arm.gnu.Tools;
import org.eclipse.cdt.cross.arm.gnu.yagarto.windows.PathResolver;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.cdt.managedbuilder.internal.envvar.BuildEnvVar;

public class ConfigurationEnvironmentSupplier
implements IConfigurationEnvironmentVariableSupplier {
    static final String VARNAME_PATH = "PATH";
    static final String DELIMITER_UNIX = ":";
    static final String PROPERTY_DELIMITER = "path.separator";

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (!Tools.isWindows()) {
            return null;
        }
        if (variableName == null) {
            return null;
        }
        if (!VARNAME_PATH.equalsIgnoreCase(variableName)) {
            return null;
        }
        String p = PathResolver.getBinPath();
        if (p != null) {
            String sDelimiter = System.getProperty(PROPERTY_DELIMITER, DELIMITER_UNIX);
            String sPath = p.replace('/', '\\');
            return new BuildEnvVar(VARNAME_PATH, sPath, 3, sDelimiter);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        IBuildEnvironmentVariable[] tmp = new IBuildEnvironmentVariable[]{this.getVariable(VARNAME_PATH, configuration, provider)};
        if (tmp[0] != null) {
            return tmp;
        }
        return null;
    }
}

