/** \file buttons.c
 * \brief <      >
 * \par
 * <       >
 * \par \author ARV \par
 * \note <  >
 * \n :
 * \n \date	25.02.2015
 * \par
 * \version <>.	\par
 * Copyright 2015  ARV. All rights reserved.
 * \par
 *   :\n
 * 	-# Atmel Toolchain 3.4.5    
 *
 */

#include <avr/io.h>
#include <avr_helper.h>
#include <avr/interrupt.h>
#include "buttons.h"

static volatile uint8_t key;
static volatile uint8_t timeout;

#if defined(AUTO_CANCEL_SEC_DELAY)
uint8_t auto_cancel;
#endif

//   
INIT(7){
	//   
	DDRD &= ~ANY_BTN;
	PORTD |= ANY_BTN;
	//      
	TIMSK = _BV(TOIE0);
	//      1024
	TCCR0 = TIMER_CLK_DIV_1024;
}

#define SEC_CNT		30

//      -   30   
//    8 
ISR(TIMER0_OVF_vect){
#if defined(AUTO_CANCEL_SEC_DELAY)
	static uint8_t cnt = SEC_CNT;

	if(!--cnt){
		cnt = SEC_CNT;
		//       
		if(auto_cancel) auto_cancel--;
	}
#endif
	key = ~PIND & ANY_BTN;	//  
	if(timeout) timeout--;	//   ,   
}

/**    .
 *    #wait_key    ,    .   
 * #LONG_DELAY     ,      
 * #SHORT_DELAY
 * @return     #K_NONE
 */
buttons get_key(void){
	static uint8_t first = 0;

	if(key == K_NONE){
		//     -   
		first = 0;
		timeout = first;
		//    
		return K_NONE;
	}

	if(!first){
		//     -    
		first = LONG_DELAY;
		timeout = first;
		//      
		return key;
	}

	//      
	//    
	while(timeout && (key != K_NONE));
	//       
	timeout = SHORT_DELAY;
	//    
	return key;
}

/**   .
 *           ,   
 *    .      
 * #LONG_DELAY  #SHORT_DELAY
 * @return     #_NONE.
 */
buttons wait_key(void){
	static uint8_t first = LONG_DELAY;
	buttons old;

	// ,    
	do{
		//    ,      
		if(key == K_NONE) first = LONG_DELAY;
	} while (key == K_NONE);

	//   
	timeout = first;
	do{
		//     
		old = key;
		if(!timeout) {
			//   -   
			first = SHORT_DELAY;
			//    
			return old;
		}
		//     
	} while (key != K_NONE);
	//   , 
	//        ,
	//      ,    
	return first <= SHORT_DELAY ? K_NONE : old;
}
