/** \file display.c
 * \brief    .
 * \par
 *       .
 *    LCD.
 * \par \author ARV \par
 * \note
 * \n :
 * \n \date	25.02.2015
 * \par
 * \version <>.	\par
 * Copyright 2015  ARV. All rights reserved.
 * \par
 *   :\n
 * 	-# Atmel Toolchain 3.4.5    
 *
 */

#include <avr/io.h>
#include <avr_helper.h>
#include <string.h>

#include "display.h"
#include "lcd.h"

static uint8_t cursor_x = 0;
static uint8_t cursor_y = 0;

void display_nprn(uint8_t *s){
	uint8_t i = 0;
	lcd_gotoxy(0, cursor_y);
	while(*s && (i<DISPLAY_WIDTH)){
		display_putc(*s++);
		i++;
	}
	while(i<DISPLAY_WIDTH){
		lcd_putc(' ');
		i++;
	}
	lcd_gotoxy(cursor_x, cursor_y);
}

/**    
 *
 * @param x   
 */
void set_cursor_x(uint8_t x){
	cursor_x = x;
	lcd_gotoxy(cursor_x, cursor_y);
}

/**    
 *
 * @param y  
 */
void set_cursor_y(uint8_t y){
	cursor_y = y;
	lcd_gotoxy(cursor_x, cursor_y);
}

/**    
 *
 * @return    
 */
uint8_t get_cursor_x(void){
	return cursor_x;
}

/**    
 *
 * @return  
 */
uint8_t get_cursor_y(void){
	return cursor_y;
}

/**  
 *
 */
void clrscr(void){
	cursor_x = 0;
	cursor_y = 0;
	lcd_clrscr();
	visible_cursor(0);
}

/**    
 *
 * @param on 0 - ,  - .
 */
void visible_cursor(uint8_t on){
	lcd_command(on ? LCD_DISP_ON_CURSOR : LCD_DISP_ON);
}

// Recode table
static const __flash uint8_t recode[] = {
//                                    
   0x41, 0xA0, 0x42, 0xA1, 0xE0, 0x45, 0xA3, 0xA4,
//                                    
   0xA5, 0xA6, 0x4B, 0xA7, 0x4D, 0x48, 0x4F, 0xA8,
//                                    
   0x50, 0x43, 0x54, 0xA9, 0xAA, 0x58, 0xE1, 0xAB,
//                                    
   0xAC, 0xE2, 0xAD, 0xAE, 0x62, 0xAF, 0xB0, 0xB1,
//                                    
   0x61, 0xB2, 0xB3, 0xB4, 0xE3, 0x65, 0xB6, 0xB7,
//                                    
   0xB8, 0xB9, 0xBA, 0xBB, 0xBC, 0xBD, 0x6F, 0xBE,
//                                    
   0x70, 0x63, 0xBF, 0x79, 0xE4, 0x78, 0xE5, 0xC0,
//                                    
   0xC1, 0xE6, 0xC2, 0xC3, 0xC4, 0xC5, 0xC6, 0xC7
 };

/**    .
 *        .
 * @param c  
 */
void display_putc(char c){
	if (c == 0xA8) // 
	   c = 0xA2;
	else if (c == 0xB8) //
	   c = 0xB5;
	else if (c >= 0xC0) // 
	   c = recode[c - 0xC0];
	lcd_putc(c);
}

/**      .
 *   .
 * @param s  
 */
void display_prn(uint8_t *s){
	while(*s) display_putc(*s++);
	lcd_gotoxy(cursor_x, cursor_y);
}

/**    flash.
 *    size    .
 * @param s   flash
 * @param size   
 */
void display_fnprn(fchar *s, uint8_t size){
	for(;size && *s; size--, s++) display_putc(*s);
	lcd_gotoxy(cursor_x, cursor_y);
}

//  
INIT(7){
	//  
	lcd_init(LCD_DISP_ON);

}

