/** \file main.c
 * \brief <      >
 * \par
 * <       >
 * \par \author ARV \par
 * \note <  >
 * \n :
 * \n \date	26 . 2015 .
 * \par
 * \version <>.	\par
 * Copyright 2015  ARV. All rights reserved.
 * \par
 *   :\n
 * 	-# Atmel Toolchain 3.4.5    
 *
 */

#include <avr/io.h>
#include <avr_helper.h>
#include <avr/interrupt.h>
#include <string.h>

#include "config.h"
#include "timekeep.h"
#include "display.h"
#include "buttons.h"
#include "editor.h"
#include "program.h"
#include "memory.h"
#include "power.h"

#define K_SETUP_TIME	K_OK
#define K_SETUP_PROG	K_CANCEL

MAIN(){
	timedate td;
	uint8_t chanel;
	uint8_t port;
	uint8_t mask;
	DDR(OUTPUT_TO_PORT) = 255;
	sei();
	while(1){
		//   - 
		check_sleep_or_not();

		if(quarter_sec){
			//  1/4   :   
			quarter_sec = 0;
			set_cursor_x(0);
			set_cursor_y(0);
			show_date(&time);
			set_cursor_y(1);
			show_time(&time);

			//  
			port = 0;
			mask = 1;
			//     
			get_time(&td);
			//     
			start_memory(0);
			for(uint8_t i=0; i<CHANEL_NUM; i++){
				//start_memory_chanel(i);
				//    ,       0
				if(execute(&td)) port |= mask;
				mask <<= 1;
			}
			//    
			PORT(OUTPUT_TO_PORT) = port;
		}
		//   
		switch(get_key()){
		case K_SETUP_TIME:	// _ -  
			get_time(&td);
			if(edit_timedate(&td) == EDIT_OK){
				td.quarter = 0;
				set_time(&td);
			}
			break;
		case K_SETUP_PROG:
			//     
			chanel = 0;
			while(view_chanel(&chanel) == EDIT_OK){
				if(edit_chanel(chanel) == EDIT_OK){
					//     ? ,  
				}
			}
			clrscr();
			break;
		default:
			break;
		}
	}
}
