/** \file memory.c
 * \brief <      >
 * \par
 * <       >
 * \par \author ARV \par
 * \note <  >
 * \n :
 * \n \date	27 . 2015 .
 * \par
 * \version <>.	\par
 * Copyright 2015  ARV. All rights reserved.
 * \par
 *   :\n
 * 	-# Atmel Toolchain 3.4.5    
 *
 */

#include <avr/io.h>
#include <avr_helper.h>
#include <avr/eeprom.h>

#include "config.h"
#include "memory.h"
#include "program.h"

static uint16_t pointer;

static const uint16_t TOTAL_MEMORY_BYTES =	(E2END+1);

void start_memory(memptr p){
	pointer = p;
}

void memory_bakward(uint8_t d){
	pointer -= d;
}

uint8_t get_byte(void){
	return eeprom_read_byte((void*)pointer++);
}

void set_byte(uint8_t data){
	eeprom_write_byte((void*)pointer++, data);
}

uint16_t get_free_memory(void){
	memptr tmp = pointer;
	uint16_t free = TOTAL_MEMORY_BYTES;
	start_memory(0);

	for(uint8_t i = 0; i<CHANEL_NUM; i++){
		while(get_byte() != TOC_LAST) free--;
		free--;
	}
	start_memory(tmp);
	return free;
}

void start_memory_chanel(uint8_t ch){
	start_memory(0);
	for(uint8_t i = 0; i<ch; i++){
		while(get_byte() != TOC_LAST);
	}
}

memptr get_memory_chanel(uint8_t ch){
	memptr tmp = pointer;
	start_memory_chanel(ch);
	memptr tmp2 = pointer;
	start_memory(tmp);
	return tmp2;
}

static uint8_t get_program_len(void){
	memptr tmp = pointer;
	uint8_t len = 0;
	while(get_byte() != TOC_LAST) len++;
	start_memory(tmp);
	return ++len;
}

/**   EEPROM.
 *    -   .
 * \note  -!    EEPROM   .
 * @param v_dst  -
 * @param v_src  -
 * @param c   
 */
void ememmove(void *v_dst, const void *v_src, uint16_t c){
	const char *src = v_src;
	char *dst = v_dst;

	if (!c)	return;

	/* Use memcpy when source is higher than dest */
	if (v_dst <= v_src){
		for(;c;c--)
			eeprom_update_byte((void*)v_dst++, eeprom_read_byte(v_src++));
		return;
	}

	/* copy backwards, from end to beginning */
	src += c;
	dst += c;

	/* Simple, byte oriented memmove. */
	while (c--)
		eeprom_update_byte((void*)--dst, eeprom_read_byte((void*)--src));

	return;
}

/**       EEPROM
 *
 * @param ch  
 * @param sz   
 * @param src -
 */
void save_chanel(uint8_t ch, uint8_t sz, const uint8_t *src){
	uint16_t next = 0;
	uint16_t free = get_free_memory();
	uint16_t occuped = TOTAL_MEMORY_BYTES - free;

	start_memory_chanel(ch);
	uint8_t len = get_program_len();
	if(free+len >= sz){
		if(ch < CHANEL_NUM-1)
			next = pointer+len;
		if(next != 0){
			ememmove((void*)pointer+sz, (void*)next, occuped-len);
		}
		start_memory_chanel(ch);
		eeprom_update_block((void*)src, (void*)pointer, sz);
	}
}

void clear_memory(void){
	start_memory(0);
	for(uint8_t i=0; i<CHANEL_NUM; i++) set_byte(TOC_LAST);
}


INIT(7){
/*
 *     ""  -  ,   
 *  .
 *
 */
#if(USE_DEMO_ALARM !=0)
static const uint8_t demo_alarm[] =
	"W\0\4,h\7\7,m\0\0,s\0\x1E\xFF";

#define SZ_ALARM 18
	save_chanel(0, SZ_ALARM, demo_alarm);
#else
#define SZ_ALARM 0
#endif

#if(USE_DEMO_SOS != 0)
static const uint8_t demo_sos[] =
	"((s\0\0,(q\0\0/q\2\2))/(s\1\1,q\0\0))/(s\2\4,q\0\2)/((s\5\5,(q\0\0/q\2\2))/(s\6\6,q\0\0))\xFF";

#define SZ_SOS 69
	save_chanel(0+USE_DEMO_ALARM, SZ_SOS, demo_sos);
#else
#define SZ_SOS 0
#endif

#if(USE_DEMO_KUKU != 0)
static const uint8_t demo_kuku[] = "m\0\0,q\1\1,((h\0\0/h\x0C\x0C),s\0\x0B)/((h\1\1/h\x0D\x0D),s\0\0)/((h\2\2/h\x0E\x0E),s\0\1)"
		"/((h\3\3/h\x0F\x0F),s\0\2)/((h\4\4/h\x10\x10),s\0\3)/((h\5\5/h\x11\x11),s\0\4)/((h\6\6/h\x12\x12),s\0\5)/((h\7\7/h\x13\x13),s\0\6)"
		"/((h\x08\x08/h\x14\x14),s\0\7)/((h\x09\x09/h\x15\x15),s\0\x08)/((h\x0A\x0A/h\x16\x16),s\0\x09)/((h\x0B\x0B/h\x17\x17),s\0\x0A)"
		"\xFF";

#define SZ_KUKU 237
	save_chanel(0+USE_DEMO_SOS+USE_DEMO_ALARM, sizeof(demo_kuku)-1, demo_kuku);
#else
#define SZ_KUKU 0
#endif
}

#if(SZ_KUKU + SZ_SOS + SZ_ALARM) > (E2END+1)
#error Sorry, size of samples greater then EEPROM memory size!
#endif
