/** \file power.c
 * \brief <      >
 * \par
 * <       >
 * \par \author ARV \par
 * \note <  >
 * \n :
 * \n \date	26 . 2015 .
 * \par
 * \version <>.	\par
 * Copyright 2015  ARV. All rights reserved.
 * \par
 *   :\n
 * 	-# Atmel Toolchain 3.4.5    
 *
 */

#include <avr/io.h>
#include <avr_helper.h>
#include <avr/sleep.h>
#include <avr/pgmspace.h>
#include <util/delay.h>
#include "display.h"
#include "lcd.h"

INIT(7){
	DDRB &= ~_BV(PB0); //   
	PORTB &= _BV(PB0);
	OSCCAL = 0xFF;			// TURBO
	ACSR = _BV(ACD);	//  
}

/**     .
 *    ,     ,  .
 *          ,
 *   ( )   ,    ,
 *  .  ,        ,  
 *       .   
 *     .
 */
void check_sleep_or_not(void){
#if defined(DDRA)
	uint8_t porta, ddra;
#endif
	uint8_t ddrb, ddrc, ddrd;
	uint8_t portb, portc, portd;

	//      -  
	if((PINB & _BV(PB0))) return;
	//   -   
	clrscr();
	display_fnprn(PSTR("Sleeping...\n   Z.z.z..."),32);
	//    
#if defined(DDRA)
	ddra = DDRA;
#endif
	ddrb = DDRB;
	ddrc = DDRC;
	ddrd = DDRD;
#if defined(PORTA)
	porta = PORTA;
#endif
	portb = PORTB;
	portc = PORTC;
	portd = PORTD;
	//   ,      
#if defined (PORTA)
	PORTA= 0;
#endif
	PORTB = 0;
	PORTC = 0;
	PORTD = 0;
#if defined(DDRA)
	DDRA = 0xFF;
#endif
	DDRB = 0xFE; // !
	DDRC = 0xFF;
	DDRD = 0xFF;
	//  -
	OSCCAL = 0;
	// 
	do{
		set_sleep_mode(SLEEP_MODE_PWR_SAVE);
		sleep_mode();
		//     ,       
	}while(!(PINB & _BV(PB0)));

	//  -
	OSCCAL = 0xFF;
	_delay_ms(100);
	//   
#if defined(PORTA)
	PORTA = porta;
#endif
	PORTB = portb;
	PORTC = portc;
	PORTD = portd;
#if defined(DDRA)
	DDRA = ddra;
#endif
	DDRB = ddrb;
	DDRC = ddrc;
	DDRD = ddrd;
	//  
	lcd_init(LCD_DISP_ON);
	clrscr();
}
