/** \file program.c
 * \brief <      >
 * \par
 * <       >
 * \par \author ARV \par
 * \note <  >
 * \n :
 * \n \date	27 . 2015 .
 * \par
 * \version <>.	\par
 * Copyright 2015  ARV. All rights reserved.
 * \par
 *   :\n
 * 	-# Atmel Toolchain 3.4.5    
 *
 */

#include <avr/io.h>
#include <avr_helper.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "config.h"
#include "program.h"
#include "memory.h"

//      20  -     
#define STACK_DEPTH		20

typedef struct {
	uint8_t head;
	uint8_t stack[STACK_DEPTH];
}stack;

static void initstack(stack *s){
	s->head = 0;
	//memset(s->stack,0,STACK_DEPTH);
}

static void push(stack *s, uint8_t d){
	s->stack[s->head++] = d;
}

static uint8_t pop(stack *s){
	return s->stack[--(s->head)];
}


/**  .
 *
 * @param t    
 * @return   1  0
 */
static uint8_t eval(uint8_t c, timedate *t){
	uint8_t v1, v2, v3;
	//  
	switch(c){
	//      -    
	case TOC_WDAY:	v1 = t->wd;			break;
	case TOC_DAY:	v1 = t->d;			break;
	case TOC_MON:	v1 = t->m;			break;
	case TOC_YEAR:	v1 = t->y;			break;
	case TOC_HOUR:	v1 = t->hour;		break;
	case TOC_MIN:	v1 = t->min;		break;
	case TOC_SEC:	v1 = t->sec;		break;
	case TOC_QUART:	v1 = t->quarter;	break;
	default:
		//    -  0  
		return 0;
	}
	//   
	v2 = get_byte();
	v3 = get_byte();
	//   
	return (v1 >= v2) && (v1 <= v3);
}

/**     
 *
 * @param t    
 * @return    0  1
 */
uint8_t execute(timedate *t){
	stack val, op;
	uint8_t byte, v1,v2,v3, start = 0;

	initstack(&val); initstack(&op);

	while(1){
		byte = get_byte();
		switch(byte){
		case TOC_BR0:
			push(&op, byte);
			break;
		case TOC_LAST:
			if(start == 0) return 0;
			// break   -   
		case TOC_BR1:
			while(1){
				if(op.head == 0)
					return pop(&val);
				switch(pop(&op)){
				case TOC_OR:
					v1 = pop(&val);
					v2 = pop(&val);
					v3 = v1 || v2;
					push(&val, v3);
					break;
				case TOC_AND:
					v1 = pop(&val);
					v2 = pop(&val);
					v3 = v1 && v2;
					push(&val, v3);
					break;
				case TOC_BR0:
					goto m1;
				}
			}
			m1:
			break;
		case TOC_OR:
		case TOC_AND:
			push(&op, byte);
			break;
		default:
			if(!start) start++;
			push(&val, eval(byte, t));
			break;
		}
	}
}

static uint8_t decompose_value(uint8_t c, uint8_t v){
	switch(c){
	case TOC_WDAY:
	case TOC_DAY:
		return v+1;
	default:
		return v;
	}
}

static uint8_t compose_value(uint8_t c, uint8_t v){
	switch(c){
	case TOC_WDAY:
	case TOC_DAY:
		return v-1;
	default:
		return v;
	}
}

/**        
 *
 * @param dst -,     #MAX_SOURCE_LEN 
 */
void decompose(uint8_t *dst){
	uint8_t pos = 0;
	uint8_t byte, v1,v2;
	uint8_t tmp[5];

	//   -
	memset(dst, 0, MAX_SOURCE_LEN);
	//    
	while((byte = get_byte()) != TOC_LAST){
		switch(byte){
		//     
		case TOC_BR0:
			if(pos && (dst[pos-1] != TOC_OR) && (dst[pos-1] != TOC_BR0) && (dst[pos-1] != TOC_AND)) dst[pos++] = TOC_AND;
		//          - break  
		case TOC_BR1:
		case TOC_OR:
		case TOC_AND:
			//      -
			dst[pos++] = byte;
			break;
		// -  ,          
		//   
		case TOC_WDAY:
		case TOC_DAY:
		case TOC_MON:
		case TOC_YEAR:
		case TOC_HOUR:
		case TOC_MIN:
		case TOC_SEC:
		case TOC_QUART:
			if(pos && (dst[pos-1] != TOC_OR) && (dst[pos-1] != TOC_BR0) && (dst[pos-1] != TOC_AND)) dst[pos++] = TOC_AND;
			dst[pos++] = byte;
			//       
			dst[pos++] = TOC_EQUAL;
			// break   -   
		default:
			//      
			v1 = decompose_value(byte,get_byte());
			v2 = decompose_value(byte,get_byte());
			itoa(v1, (char*)tmp, 10);
			strcat((char*)dst+pos, (char*)tmp);
			pos += strlen((char*)tmp);
			//     -   
			if(v1 == v2) continue;
			//    -  
			dst[pos++] = TOC_INTERVAL;
			itoa(v2, (char*)tmp, 10);
			strcat((char*)dst+pos, (char*)tmp);
			pos += strlen((char*)tmp);
			break;
		}
	}
}

/**   -     
 *       ,     ,   
 *   .
 * @param src -
 * @return    (  strlen  !)
 */
uint8_t compose(uint8_t *src){
	uint8_t v1, tp;
	uint8_t c;
	uint8_t *dst = src;
	uint8_t len = 0;
	uint8_t tmp[3];

	//    
	while(c = *src++){ //  Warning -  
		switch(c){
		// -
		case TOC_WDAY:
		case TOC_DAY:
		case TOC_MON:
		case TOC_YEAR:
		case TOC_HOUR:
		case TOC_MIN:
		case TOC_SEC:
		case TOC_QUART:
			//     
			src++;
			*dst++ = c; len++;
			tp = 0;
			//       
			memset(tmp,0,sizeof(tmp));
			while((src[tp] >= '0') && (src[tp] <= '9')){
				tmp[tp] = src[tp];
				tp++;
			}
			v1 = atoi((char*)tmp);
			*dst++ = compose_value(c,v1); len++;
			src += tp;
			//   -   2 
			if(*src == TOC_INTERVAL){
				src++;
				tp = 0;
				memset(tmp,0,sizeof(tmp));
				while((src[tp] >= '0') && (src[tp] <= '9')){
					tmp[tp] = src[tp];
					tp++;
				}
				v1 = atoi((char*)tmp);
			}
			*dst++ = compose_value(c,v1); len++;
			break;
		case TOC_BR0:
		case TOC_BR1:
		case TOC_OR:
		case TOC_AND:
			//         
			*dst++ = c; len++;
			break;
		case TOC_EQUAL:
			break;
		}
	}
	//       
	*dst++ = TOC_LAST;
	return ++len;
}

