/** \file timekeep.c
 * \brief <      >
 * \par
 * <       >
 * \par \author ARV \par
 * \note <  >
 * \n :
 * \n \date	26 . 2015 .
 * \par
 * \version <>.	\par
 * Copyright 2015  ARV. All rights reserved.
 * \par
 *   :\n
 * 	-# Atmel Toolchain 3.4.5    
 *
 */

#include <avr/io.h>
#include <avr_helper.h>
#include <avr/interrupt.h>
#include <util/atomic.h>
#include <string.h>

#include "timekeep.h"

uint8_t quarter_sec;

INIT(7){
	//  
	ASSR = _BV(AS2);				//    2
	while(ASSR != _BV(AS2));		// ,  
	TIFR = _BV(TOV2);				//  
	TIMSK |= _BV(TOIE2);			//    
	TCCR2 = _BV(CS21) | _BV(CS20);	//  32
	//  
	time.quarter = 0;
	time.sec = 0;
	time.min = 0;
	time.hour = 12;
	time.m = 0;
	time.d = 0;
	time.wd = 0;
	time.y = 15;
}

///   
timedate time;
/// ,   1/4 
uint8_t quarter_sec;

///    2 -  
ISR(TIMER2_OVF_vect){
	//    1/4  -  
	quarter_sec = 1;
	if(++time.quarter >= 4){
		//  
		time.quarter = 0;
		if(++time.sec >= 60){
			//  
			time.sec = 0;
			if(++time.min >= 60){
				//  
				time.min = 0;
				if(++time.hour >= 24){
					//  
					time.hour = 0;
					if(++time.wd >= 7) time.wd = 0;
					if(++time.d >= get_month_len(&time)){
						//  
						time.d = 0;
						if(++time.m >= 12){
							//  
							time.m = 0;
							time.y++;
						}
					}
				}
			}
		}
	}
}

/**      
 *
 * @param td ,   
 */
void get_time(timedate *td){
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE){
		memcpy(td, &time, sizeof(timedate));
	}
}

/**     
 *
 * @param td ,      
 */
void set_time(timedate *td){
	ATOMIC_BLOCK(ATOMIC_RESTORESTATE){
		memcpy(&time, td, sizeof(timedate));
	}
}

static fchar mon_len[12] = {31, 0 , 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

/**      
 *
 * @param td    
 * @return     
 */
uint8_t get_month_len(timedate *td){
	if(td->m != 1)	return mon_len[td->m];	//    -    
	if(td->y % 4)	return 28;				//     -  28
	else			return 29;				//    - 29
}
